/* ms-hoover.m,
 *
 * A high flying hovercraft.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "projectiles/dumbfire.h"
#include "projectiles/maser.h"
#include "seborrhea/seborrhea.h"
#include "sound.h"
#include "units/ms-hoover.h"


static SebFile *unit_data;


@implementation MsHoover
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Maser);
}

+ derive_loadData(unit_data, "data/ms-hoover");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 120;
    critical_health = 60;
    speed = 1.02;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)
				[unit_data getSebumByName:"body"]];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[DualWeapon newWithProjectile:[Maser class]]
		setShotDelay:-20 WaveDelay:50]
	       setShotsPerWave:2]
	      setXDisplacement:25 YDisplacement:7];

    return self;
}

- (void) enableMovement
{
    [super enableMovement];

    if (flags & FLAG_MOVING_ENABLED) {
	/* Fire a couple of dumb-fire missiles. */
	[spawn_projectile([DumbfireLeft  class], x+10, y, NO) setAngle:deg2rad(-85.0)];
	[spawn_projectile([DumbfireRight class], x-10, y, NO) setAngle:deg2rad(-95.0)];

	play_panned_sample((Sebum<SebSample> *)[unit_data getSebumByName:"snd"], x);

	[(SebAnimator *)sprite setAnimation:(SebAnimation *)
			[unit_data getSebumByName:"body2"]];

	shadow = [unit_data getSebumByName:"shadow2"];
    }
}
@end
