/* mote.m,
 *
 * Little path follower ships that drop fireballs everywhere.
 * Slightly different path to Lint for confusion.
 */

#include <math.h>
#include "candy/speed-shadow.h"
#include "common.h"
#include "map-editor/unit-editor.h"
#include "map-editor/unit-extras.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"
#include "unit-seeking.h"
#include "units/all-units.h"
#include "units/mote.h"


static SebFile *unit_data;

/*--------------------------------------------------------------*/

@interface MoteTrail: RotatedSpeedShadow
@end

/*--------------------------------------------------------------*/
/* Mote abstract classes.						*/
/*--------------------------------------------------------------*/

@implementation BasicMote
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Fireball);
}

+ derive_loadData(unit_data, "data/mote");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 5;
    speed = 8.5;

    sprite = [unit_data getSebumByName:"body"];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotated_sprite = YES;

    gun = [[[Weapon newWithProjectile:[Fireball class]]
	       setShotDelay:60]
	      setFireTics:30];

    chunk_colours = CHUNK_GREEN;    
    return self;
}

- free
{
    gun = [gun free];
    return [super free];
}

- (enum THING_UPDATE_STATE) update
{
    if (game_flags & FLAG_PLAYERS_ALIVE)
	[gun fireFromX:x Y:y Angle:ANGLE_TO_CLOSEST_ALLY(x, y)];

    [spawn_candy([MoteTrail class], x, y, MEDIUM_LAYER) setAngle:angle];

    return [super update];
}
@end


@implementation BasicMote2
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(BasicMote, YES);
}

- setX:(double)x_ Y:(double)y_
{
    [super setX:x_ Y:y_];
    path_x_displacement = -25;
    angle = (mirror_path) ? M_PI : 0.0;
    return self;
}

	/* Protocol stuff. */
- derive_setActivationLine;
- derive_importUnitPropertiesWithVariableActivationLine;
- derive_exportUnitPropertiesWithVariableActivationLine;
@end


@implementation BasicMote2 (MapEditor)
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_activation_line(dest, x, y, activate_y);
}
@end

/*--------------------------------------------------------------*/
/* Motes.							*/
/*--------------------------------------------------------------*/

@implementation MoteTop
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(BasicMote, YES);
}

- init
{
    [super init];
    the_way = (SebSpline *)[unit_data getSebumByName:"path"];
    return self;
}
@end


@implementation MoteUp
- init
{
    [super init];
    speed = 4.2;
    the_way = (SebSpline *)[unit_data getSebumByName:"path-u"];
    return self;
}
@end


@implementation MoteDown
- init
{
    [super init];
    speed = 4.2;
    the_way = (SebSpline *)[unit_data getSebumByName:"path-d"];
    return self;
}
@end


@implementation MoteStrange
- init
{
    [super init];
    speed = 4.4;
    the_way = (SebSpline *)[unit_data getSebumByName:"path-s"];
    return self;
}
@end


@implementation MoteCharm
- init
{
    [super init];
    speed = 4.4;
    the_way = (SebSpline *)[unit_data getSebumByName:"path-c"];
    return self;
}
@end


/*--------------------------------------------------------------*/

@implementation MoteTrail
- init
{
    [super init];
    health = max_health = 10;
    sprite = [unit_data getSebumByName:"speedy"];
    return self;
}
@end
