/* moan.m,
 *
 * Asymmerical ship with a vulcan cannon and laser.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "projectiles/evil-vulcan.h"
#include "projectiles/pulse-laser.h"
#include "seborrhea/seborrhea.h"
#include "units/moan.h"


static SebFile *unit_data;


@implementation Moan
+ (BOOL) loadPrerequisites
{
    return (LOAD_PROJECTILE_DATA_FOR(EvilVulcan) &&
	    LOAD_PROJECTILE_DATA_FOR(PulseLaser));
}

+ derive_loadData(unit_data, "data/moan");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 55;
    speed = 0.6;

    sprite = [unit_data getSebumByName:"body"];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotated_sprite = YES;

    gun = [[[[OffcentrePulseWeapon newWithProjectile:[EvilVulcan class]]
		setShotDelay:3 WaveDelay:40]
	       setShotsPerWave:2]
	      setXDisplacement:15 YDisplacement:-15];
    laser = [[[OffcentreWeapon newWithProjectile:[PulseLaser class]]
		 setShotDelay:100]
		setXDisplacement:15 YDisplacement:15];

    chunk_colours = CHUNK_GREEN;
    return self;
}

- free
{
    if (laser)
	laser = [laser free];
    return [super free];
}

- (void) fireProjectiles
{
    [gun    fireFromX:x Y:y Angle:angle];
    [laser  fireFromX:x Y:y Angle:angle];
}
@end
