/* miniboss2.m,
 *
 * The collection of turrets made for the ship miniboss.
 */

#include <math.h>
#include "candy.h"
#include "common.h"
#include "projectiles/plasma.h"
#include "projectiles/shockwave.h"
#include "seborrhea/seborrhea.h"
#include "units/all-units.h"
#include "units/cluster-bomb.h"
#include "units/miniboss2.h"


static SebFile *mini2_sebum;

/*--------------------------------------------------------------*/

@interface Mini2BaseDebris: Candy
@end

@interface Mini2CannonDebris: Candy
@end

/*--------------------------------------------------------------*/

@implementation AbstractMini2Turret
+ (BOOL) loadData
{
    if (mini2_sebum)
	return YES;

    mini2_sebum = [SebFile new];
    if (not [mini2_sebum loadSebumDirectory:"data/miniboss2"])
	return NO;

    return YES;
}

+ derive_shutdown(mini2_sebum);

- init
{
    [super init];

    health = 800;
    critical_health = 400;

    sprite = [mini2_sebum getSebumByName:"base"];
    w = [sprite width];
    h = [sprite height];

    base_debris = [Mini2BaseDebris class];

    chunk_colours = CHUNK_RED;
    return self;
}
@end

/*--------------------------------------------------------------*/

@implementation Mini2Turret
+ (BOOL) loadPrerequisites
{
    return (LOAD_UNIT_DATA_FOR(AbstractMini2Turret, NO) &&
	    LOAD_PROJECTILE_DATA_FOR(Plasma));
}

- init
{
    [super init];

    turret = [mini2_sebum getSebumByName:"turret"];

    gun = [[[DualWeapon newWithProjectile:[Plasma class]]
	       setShotDelay:10 WaveDelay:50]
	      setXDisplacement:13 YDisplacement:6];

    return self;
}
@end

/*--------------------------------------------------------------*/

@implementation Basturk
+ (BOOL) loadPrerequisites
{
    return (LOAD_UNIT_DATA_FOR(AbstractMini2Turret, NO) &&
	    LOAD_PROJECTILE_DATA_FOR(Shockwave));
}

- init
{
    [super init];

    turret = [mini2_sebum getSebumByName:"basturk"];

    gun = [[[DualWeapon newWithProjectile:[Shockwave class]]
	       setShotDelay:20 WaveDelay:60]
	      setXDisplacement:13 YDisplacement:8];

    return self;
}
@end

/*------------------------------------------------------------*/

@implementation Mini2Cannon
+ (BOOL) loadPrerequisites
{
    return (LOAD_UNIT_DATA_FOR(AbstractMini2Turret, NO) &&
	    LOAD_UNIT_DATA_FOR(ClusterBomb, YES));
}

+ derive_loadData(mini2_sebum, "data/miniboss2-cannon");
+ derive_shutdown(mini2_sebum);

- init
{
    [super init];

    health = 1600;
    critical_health = 800;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)
				[mini2_sebum getSebumByName:"cannon"]];
    w = [sprite width] - 6;
    h = [sprite height];

    base_debris = [Mini2CannonDebris class];

    return self;
}

- (void) fire
{
    fire_tics--;

    if (fire_tics < 0) {
	x++;

	if (fire_tics <= -10)
	    fire_tics = 2.5*SECONDS;
    }    
    else if ((fire_tics <= 16) &&
	(fire_tics % 4) == 0) {
	double theta = rnd_with_rng(-10, 10);

	x -= 2;

	[spawn_unit([ClusterBomb class], x+25, y-1, ACTIVE_AIR_LIST, YES)
		   setAngle:deg2rad(theta)];

	if (fire_tics == 16)
	    [(SebAnimator *)sprite resetAnimation];
    }
}
@end

/*--------------------------------------------------------------*/

@implementation Mini2BaseDebris
- init
{
    [super init];
    sprite = [mini2_sebum getSebumByName:"deb"];
    return self;
}
@end


@implementation Mini2CannonDebris
- init
{
    [super init];
    sprite = [mini2_sebum getSebumByName:"candeb"];
    return self;
}
@end
