/* mine.m,
 *
 * A small unit that instantly dies when touched by a ship, but is
 * strong to projectiles.
 */

#include <assert.h>
#include <math.h>
#include "common.h"
#include "seborrhea/seborrhea.h"
#include "units/mine.h"


static SebFile *mine_sebum;


@implementation Mine
+ derive_loadData(mine_sebum, "data/mine");
+ derive_shutdown(mine_sebum);

- init
{
    [super init];

    health = 200;
    speed = 1.50;

    sprite = [mine_sebum getSebumByName:"body"];
    shadow = [mine_sebum getSebumByName:"shadow"];
    w = 17; /* [sprite width]; */
    h = 15; /* [sprite height]; */
    
    return self;
}

- (int) receiveDamage:(int)damage type:(enum DAMAGE_TYPE)type
{
    /* Insta-kill on contact with unit, but not projectiles. */
    if (type == DAMAGE_TYPE_UNIT)
	damage = health;

    return [super receiveDamage:damage type:type];
}

- (void) move
{
    [super move];

    speed *= 0.99;
/*     if (speed > 0.30) */
/* 	speed -= 0.02; */
}
@end
