/* mine-layer.m,
 *
 * A unit that drops a bunch of mines at a time.  Each difficulty up
 * results in an extra mine laid out.
 */

#include <assert.h>
#include <math.h>
#include "common.h"
#include "difficulty.h"
#include "rotate.h"
#include "seborrhea/seborrhea.h"
#include "units/all-units.h"
#include "units/mine-layer.h"
#include "units/mine.h"


static SebFile *unit_data;


@implementation MineLayer
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(Mine, YES);
}

+ derive_loadData(unit_data, "data/mine-layer");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 150;
    critical_health = 75;
    speed = 1.2;

    sprite = [[SebAnimatorManual new] setAnimation:(SebAnimation *)
				      [unit_data getSebumByName:"fire-anim"]];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height] - 12;
    rotated_sprite = YES;

    fire_tics = 50;
    shot_num = 0;
    flags |= FLAG_FIRING_ENABLED;

    return self;
}

- (void) fire
{
    const double alpha[3 + NUM_DIFFICULTY_LEVELS-1] = {
	deg2rad( 7.5), -deg2rad(22.5),  deg2rad( 0.0),  deg2rad(22.5),
	-deg2rad( 7.5),  deg2rad(17.5), -deg2rad(17.5)
    };

    fire_tics--;
    if (fire_tics <= 0) {
	double xx, yy;

	rotate(-10, 0, angle, &xx, &yy);
	[spawn_unit([Mine class], x+xx, y-yy, ACTIVE_AIR_LIST, YES)
		   setAngle:M_PI + angle + alpha[shot_num]];

	shot_num++;
	if (shot_num >= 3+(int)difficulty) {
	    shot_num = 0;
	    fire_tics = 75;

	    [(SebAnimator *)sprite nextFrame];
	}
	else {
	    fire_tics = 5;

	    if (shot_num == 1)
		[(SebAnimator *)sprite nextFrame];
	}
    }
    else if (fire_tics == 10) {
	[(SebAnimator *)sprite nextFrame];
    }
}
@end
