/* micronuke.m,
 *
 * Not actually a nuke.  Just a helper unit to clear away some bullets
 * (but not units) around the player when he gets hit.
 */

#include "common.h"
#include "units/micronuke.h"


@implementation MicroNuke
- init
{
    [super init];

    health = 8;
    w = 40;
    h = 40;
    flags |= FLAG_INVINCIBLE;

    return self;
}

- (void) draw:(BITMAP *)_
{
    /* No pic (yet?). */
    (void)_;
}

- (enum THING_UPDATE_STATE) update
{
    health--;
    if (health <= 0)
	return THING_DEAD;
    else
	return THING_NORMAL;
}

- (BOOL) checkCollisionWith:(Thing<DetectsCollision> *)object
{
    /* Do a circle-circle collision detection, just like a nuke. */
    double x2, y2;
    int w2, h2;

    [object getX:&x2 Y:&y2 W:&w2 H:&h2];

    return (SQ(x2-x) + SQ(y2-y) <= SQ(12.0));
}

- (int) collisionRoutinePriority { return COLLISION_PRIORITY_HIGHEST-1; }
- (int) collisionLists { return COLLIDES_WITH_PROJECTILES; }
@end
