/* lizard.m,
 *
 * A double-barrelled tank.
 */

#include <math.h>
#include "candy/tank-track.h"
#include "candy/turret.h"
#include "common.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"
#include "units/lizard.h"


static SebFile *tank_data;
static SebAnimation *move_anim, *fire_left, *fire_right;

/*------------------------------------------------------------*/

@interface LizardTrack: TankTrack
@end

@interface LizardTurretDebris: TurretDebris
@end

/*------------------------------------------------------------*/

@implementation Lizard
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Fireball);
}

+ (BOOL) loadData
{
    if (not [self loadData:&tank_data :"data/lizard"])
	return NO;

    move_anim  = (SebAnimation *)[tank_data getSebumByName:"move"];
    fire_left  = (SebAnimation *)[tank_data getSebumByName:"fire-l"];
    fire_right = (SebAnimation *)[tank_data getSebumByName:"fire-r"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(tank_data);
    move_anim  = nil;
    fire_left  = nil;
    fire_right = nil;
}

- init
{
    [super init];

    health = 80;
    speed = 0.5;
    activate_y = -100;

    sprite = [[SebAnimatorManualWithDelay new] setAnimation:move_anim];
    turret = [[SebAnimator new] setAnimation:fire_left];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[DualWeapon newWithProjectile:[Fireball class]]
		setShotDelay:60 WaveDelay:60]
	       setShotsPerWave:2]
	      setXDisplacement:0 YDisplacement:2];

    turret_debris = [LizardTurretDebris class];
    tracks = [LizardTrack class];
    track_separation_sq = SQ(16.0);

    chunk_colours = CHUNK_GREEN;
    return self;
}

- (void) fire
{
    if ([gun fireFromX:x Y:y Angle:turret_angle]) {
	if ([(<PulseWeapon>)gun currentShot] == 0)
	    [(SebAnimator *)turret setAnimation:fire_left];
	else
	    [(SebAnimator *)turret setAnimation:fire_right];
    }
}
@end

/*------------------------------------------------------------*/

@implementation LizardTrack
- init
{
    [super init];
    health = max_track_life = 200;
    sprite = [tank_data getSebumByName:"tracks"];
    return self;
}
@end


@implementation LizardTurretDebris
- init
{
    [super init];
    sprite = [fire_left getFrame:-1];
    health = max_health = 60;
    return self;
}
@end
