/* little-death.m,
 *
 * Parabolic path followers that give nuke powerups upon death.
 */

#include <math.h>
#include "common.h"
#include "powerup.h"
#include "seborrhea/seborrhea.h"
#include "units/little-death.h"


static SebFile *unit_data;


@implementation LittleDeath
+ derive_loadData(unit_data, "data/little-death");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 50;
    speed = 5.0;
    the_way = (SebSpline *)[unit_data getSebumByName:"path"];

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)[unit_data getSebumByName:"move-anim"]];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height] - 6;

    /* By default, Little Death's will give you nukes. */
    flags |= FLAG_DEATH_SPAWN_NUKE_POWERUP;
    return self;
}
@end
