/* lint.m,
 *
 * A tan-shaped path following puny ship.  Weak, but annoying.
 */

#include <allegro.h>
#include <math.h>
#include "candy/speed-shadow.h"
#include "common.h"
#include "map-editor/unit-editor.h"
#include "map-editor/unit-extras.h"
#include "player.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"
#include "unit-seeking.h"
#include "units/all-units.h"
#include "units/lint.h"


static SebFile *unit_data;

/*--------------------------------------------------------------*/

@interface LintTrail: RotatedSpeedShadow
@end

/*--------------------------------------------------------------*/
/* Lint Abstract Class.						*/
/*--------------------------------------------------------------*/

@implementation BasicLint
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Fireball);
}

+ derive_loadData(unit_data, "data/lint");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 5;
    speed = 8.0;

    sprite = [unit_data getSebumByName:"lint"];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotated_sprite = YES;

    gun = [[[Weapon newWithProjectile:[Fireball class]]
	       setShotDelay:60]
	      setFireTics:30];

    group_num = 0;
    group = nil;

    chunk_colours = CHUNK_GREEN;    
    return self;
}

- free
{
    gun = [gun free];
    return [super free];
}

- (void) die
{
    if ([group dropGroupRef]) {
	/* The entire group was destroyed -> bonus score!  Give to all
	   players because it's easier and maybe both contributed. */
	if (player[0]) [player[0] increaseScore:10000];
	if (player[1]) [player[1] increaseScore:10000];
    }
    else {
	/* Don't spawn powerups. */
	flags &=~FLAG_DEATH_SPAWN_POWERUP;
    }

    [super die];
}

- (enum THING_UPDATE_STATE) update
{
    if ((gun) && (game_flags & FLAG_PLAYERS_ALIVE))
	[gun fireFromX:x Y:y Angle:ANGLE_TO_CLOSEST_ALLY(x, y)];

    [spawn_candy([LintTrail class], x, y, MEDIUM_LAYER) setAngle:angle];

    return [super update];
}

	/* Load/Save.  format: group_num;x;y;a[;flags] */
- (void) importUnitProperties:(char *)str
{
    char str2[1024];

    sscanf(str, "%d;%s", &group_num, str2);
    [super importUnitProperties:str2];

    /* Find the appropriate group to add it to. */
    group = getGroupRef(group_num);
}

- (char *) exportUnitProperties:(char *)str
{
    char str2[1024] = "\0";

    [super exportUnitProperties:str2];
    snprintf(str, sizeof(str2), "%d;%s", group_num, str2);
    return str;
}

	/* Protocols. */
- derive_setGroup(group_num);
@end


@implementation BasicLint (MapEditor)
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_group_num(dest, x, y, group_num);
}
@end

/*--------------------------------------------------------------*/
/* Lints.							*/
/*--------------------------------------------------------------*/

@implementation Lint
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(BasicLint, YES);
}

- init
{
    [super init];
    the_way = (SebSpline *)[unit_data getSebumByName:"path"];
    return self;
}
@end


@implementation LintMirror
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(BasicLint, YES);
}

- init
{
    [super init];
    the_way = (SebSpline *)[unit_data getSebumByName:"path2"];
    return self;
}
@end


@implementation LintReverse
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(BasicLint, YES);
}

- init
{
    [super init];
    angle = deg2rad(90.0);
    the_way = (SebSpline *)[unit_data getSebumByName:"path3"];
    activate_y = -screen_h;
    return self;
}
@end


@implementation LintReverse (MapEditor)
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_fixed_activation_line(dest, x, y, activate_y);
}
@end

/*--------------------------------------------------------------*/

@implementation LintTrail
- init
{
    [super init];
    health = max_health = 10;
    sprite = [unit_data getSebumByName:"speedy"];
    return self;
}
@end
