/* kamikaze.m,
 *
 * Ships that try to ram the player to death.  Many different paths.
 */

#include <assert.h>
#include "candy/smoke.h"
#include "common.h"
#include "seborrhea/seborrhea.h"
#include "unit-seeking.h"
#include "units/all-units.h"
#include "units/kamikaze.h"


static SebFile *unit_data;
static SebAnimation *kamikaze_anim;


/*--------------------------------------------------------------*/
/* Path Follower Kamikaze Abstract Class.			*/
/*--------------------------------------------------------------*/

@implementation BasicKamikaze
+ (BOOL) loadData
{
    if (not [self loadData:&unit_data :"data/kamikaze"])
	return NO;

    /* Yes, I know the shadow should change. */
    kamikaze_anim = (SebAnimation *)[unit_data getSebumByName:"move-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(unit_data);
    kamikaze_anim = nil;
}

- init
{
    [super init];

    health = 5;
    speed = 13.0;

    sprite = [[SebAnimator new] setAnimation:kamikaze_anim];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotated_sprite = YES;

    chunk_colours = CHUNK_BLUE;
    return self;
}

- (enum THING_UPDATE_STATE) update
{
    spawn_candy([Smoke class], x, y, HIGH_LAYER);
    return [super update];
}
@end


/*--------------------------------------------------------------*/
/* Path Follower Kamikazes.					*/
/*--------------------------------------------------------------*/

@implementation Kamikaze
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(BasicKamikaze, YES);
}

- init
{
    [super init];
    the_way = (SebSpline *)[unit_data getSebumByName:"path"];
    return self;
}
@end


@implementation KamikazeCenter
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(BasicKamikaze, YES);
}

- init
{
    [super init];
    the_way = (SebSpline *)[unit_data getSebumByName:"path-centre"];
    return self;
}
@end


@implementation KamikazeHook
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(BasicKamikaze, YES);
}

- init
{
    [super init];
    the_way = (SebSpline *)[unit_data getSebumByName:"path-hook"];
    return self;
}
@end


/*--------------------------------------------------------------*/
/* Flyer Kamikaze Abstract Class.				*/
/*--------------------------------------------------------------*/

@implementation BasicKamikazeFlyer
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(BasicKamikaze, YES);
}

- init
{
    /* Same as BasicKamikaze. */
    [super init];

    health = 5;
    speed = 13.0;

    sprite = [[SebAnimator new] setAnimation:kamikaze_anim];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotated_sprite = YES;

    chunk_colours = CHUNK_BLUE;
    return self;
}

- (enum THING_UPDATE_STATE) update
{
    /* Same as BasicKamikaze. */
    spawn_candy([Smoke class], x, y, HIGH_LAYER);
    return [super update];
}
@end


/*--------------------------------------------------------------*/
/* Flyer Kamikazes.						*/
/*--------------------------------------------------------------*/

@implementation KamikazeCharger
- (void) activate
{
    angle = ANGLE_TO_CLOSEST_ALLY(x, y);
}
@end
