/* interceptor.m,
 */

#include <math.h>
#include "common.h"
#include "projectiles/plasma.h"
#include "seborrhea/seborrhea.h"
#include "unit-seeking.h"
#include "units/interceptor.h"


static SebFile *unit_data;


@implementation Interceptor
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Plasma);
}

+ derive_loadData(unit_data, "data/interceptor");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 55;
    speed = 1.0;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)
				[unit_data getSebumByName:"body"]];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height] - 10;
 
    gun = [[[[[SprayWeapon newWithProjectile:[Plasma class]]
		 setShotDelay:45] setFireTics:25]
	       setShotsPerWave:3]
	      setSpray:deg2rad(20.0)];

    return self;
}

- (void) fireProjectiles
{
    [gun fireFromX:x Y:y Angle:ANGLE_TO_CLOSEST_ALLY(x, y)];
}
@end
