/* hippo.m,
 *
 * A heavily armoured tank with two barrels.
 */

#include <allegro.h>
#include <math.h>
#include "candy/tank-track.h"
#include "candy/turret.h"
#include "common.h"
#include "map.h"
#include "projectiles/plasma.h"
#include "rottrans.h"
#include "seborrhea/seborrhea.h"
#include "units/all-units.h"
#include "units/hippo.h"


static SebFile *tank_data;
static SebAnimation *move_anim, *fire_anim;

/*------------------------------------------------------------*/

@interface HippoTrack: TankTrack
@end

@interface HippoTurretDebris: TurretDebris
@end

/*------------------------------------------------------------*/

@implementation Hippo
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Plasma);
}

+ (BOOL) loadData
{
    if (not [self loadData:&tank_data :"data/hippo"])
	return NO;

    move_anim = (SebAnimation *)[tank_data getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[tank_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(tank_data);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 150;
    speed = 0.60;
    activate_y = -100;

    sprite = [[SebAnimatorManualWithDelay new] setAnimation:move_anim];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    gun = [[[DualWeapon newWithProjectile:[Plasma class]]
	       setShotDelay:0 WaveDelay:60]
	      setXDisplacement:15 YDisplacement:5];

    turret_debris = [HippoTurretDebris class];
    tracks = [HippoTrack class];
    track_separation_sq = SQ(18.0);

    chunk_colours = CHUNK_COFFEE;
    return self;
}

- (void) fire
{
    if ([gun fireFromX:x Y:y Angle:turret_angle])
	[(SebAnimator *)turret resetAnimation];
}
@end

/*------------------------------------------------------------*/

@implementation HippoHatch
+ (BOOL) loadPrerequisites
{
    return (LOAD_UNIT_DATA_FOR(Hatch, NO) &&
	    LOAD_UNIT_DATA_FOR(Hippo, NO));
}

- init
{
    [super init];
    spawnee = [Hippo class];
    return self;
}

- (void) draw:(BITMAP *)dest
{
    [super draw:dest];

    /* Fade a Hippo into existance. */
    if (spawnee && [(SebAnimatorManualWithDelay *)sprite currentFrameNumber] > 0) {
	[(<SebImage>)[tank_data getSebumByName:"hatchme"]
		     drawTo:dest X:x-offsetX Y:y-offsetY Alpha:alpha Angle:angle];
    }
}
@end

/*------------------------------------------------------------*/

@implementation HippoTrack
- init
{
    [super init];
    health = max_track_life = 150;
    sprite = [tank_data getSebumByName:"tracks"];
    return self;
}
@end

@implementation HippoTurretDebris
- init
{
    [super init];
    health = max_health = 70;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
