/* grunt.m,
 *
 * Asymmetrical ship equipped with a vulcan on the right wing and
 * dumbfire missiles on the left.
 */

#include <math.h>
#include "common.h"
#include "projectiles/dumbfire.h"
#include "projectiles/evil-vulcan.h"
#include "seborrhea/seborrhea.h"
#include "units/grunt.h"


static SebFile *unit_data;
static SebAnimation *move_anim, *fire_anim;


@implementation Grunt
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(EvilVulcan); }

+ (BOOL) loadData
{
    if (not [self loadData:&unit_data :"data/grunt"])
	return NO;

    move_anim = (SebAnimation *)[unit_data getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[unit_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(unit_data);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 30;
    speed = 0.6;

    sprite = [[SebAnimator new] setAnimation:move_anim];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width] - 12;
    h = [sprite height];
    rotated_sprite = YES;

    gun = [[[[OffcentrePulseWeapon newWithProjectile:[EvilVulcan class]]
		setShotDelay:3 WaveDelay:70]
	       setShotsPerWave:3]
	      setXDisplacement:12 YDisplacement:13];

    missile = [[[OffcentreWeapon newWithProjectile:[DumbfireLeft class]]
		   setShotDelay:100]
		  setXDisplacement:0 YDisplacement:-14];
    
    chunk_colours = CHUNK_GREEN;
    return self;
}

- free
{
    if (missile)
	missile = [missile free];
    return [super free];
}

- (enum THING_UPDATE_STATE) update
{
    if ([(SebAnimator *)sprite animationEnded])
	[(SebAnimator *)sprite setAnimation:move_anim];

    return [super update];
}

- (void) fireProjectiles
{
    [missile fireFromX:x Y:y Angle:angle+deg2rad(3.0)];

    if ([gun fireFromX:(x+rnd_with_rng(-1, 1)) Y:y Angle:angle] &&
	[(<PulseWeapon>)gun currentShot] == 1)
	[(SebAnimator *)sprite setAnimation:fire_anim];
}
@end
