/* gecko.m,
 *
 * A machine-gun turret tank.  Light armour, but still very nasty.
 */

#include "candy/tank-track.h"
#include "candy/turret.h"
#include "common.h"
#include "projectiles/evil-vulcan.h"
#include "seborrhea/seborrhea.h"
#include "units/gecko.h"


static SebFile *tank_data;
static SebAnimation *move_anim, *fire_anim;

/*------------------------------------------------------------*/

@interface GeckoTrack: TankTrack
@end

@interface GeckoTurretDebris: TurretDebris
@end

/*------------------------------------------------------------*/

@implementation Gecko
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(EvilVulcan); }

+ (BOOL) loadData
{
    if (not [self loadData:&tank_data :"data/gecko"])
	return NO;

    move_anim = (SebAnimation *)[tank_data getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[tank_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(tank_data);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 40;
    speed = 0.8;
    activate_y = -100;

    sprite = [[SebAnimatorManualWithDelay new] setAnimation:move_anim];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    gun = [[[PulseWeapon newWithProjectile:[EvilVulcan class]]
	       setShotDelay:10 WaveDelay:60]
	      setShotsPerWave:4];

    turret_debris = [GeckoTurretDebris class];
    tracks = [GeckoTrack class];
    track_separation_sq = SQ(16.0);

    chunk_colours = CHUNK_GREEN;
    return self;
}

- (void) fire
{
    if ([gun fireFromX:x Y:y Angle:turret_angle] &&
	[(<PulseWeapon>)gun currentShot] == 1) {
	[(SebAnimator *)turret resetAnimation];
    }
}
@end

/*------------------------------------------------------------*/

@implementation GeckoTrack
- init
{
    [super init];
    health = max_track_life = 150;
    sprite = [tank_data getSebumByName:"tracks"];
    return self;
}
@end


@implementation GeckoTurretDebris
- init
{
    [super init];
    health = max_health = 55;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
