/* freeze.m,
 *
 * A fixed turret that is cyan in colour.  And has wings.
 */

#include <math.h>
#include "candy.h"
#include "common.h"
#include "projectiles/shockwave.h"
#include "seborrhea/seborrhea.h"
#include "units/all-units.h"
#include "units/freeze.h"


static SebFile *turret_data;

/*--------------------------------------------------------------*/

@interface FreezeSWDebris: Candy
@end

@interface FreezeSEDebris: Candy
@end

/*--------------------------------------------------------------*/

@implementation Freeze
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Shockwave); }
+ derive_loadData(turret_data, "data/freeze");
+ derive_shutdown(turret_data);

- init
{
    [super init];

    health = 130;
    critical_health = 65;
    angle = deg2rad(-45.0);

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)
				[turret_data getSebumByName:"fire-se"]];
    w = [sprite width];
    h = [sprite height];

    gun = [[Weapon newWithProjectile:[Shockwave class]]
	      setShotDelay:30];

    chunk_colours = CHUNK_BLUE;

    base_debris = [FreezeSEDebris class];

    return self;
}

- (void) fire
{
    if ([gun fireFromX:x Y:y Angle:angle])
	[(SebAnimator *)sprite resetAnimation];
}

- derive_fixedAngle;
@end

/*--------------------------------------------------------------*/

@implementation FreezeSW
+ (BOOL) loadPrerequisites
{
    return LOAD_UNIT_DATA_FOR(Freeze, NO);
}

- init
{
    [super init];

    angle = deg2rad(-135.0);

    [(SebAnimator *)sprite setAnimation:(SebAnimation *)
		    [turret_data getSebumByName:"fire-sw"]];

    base_debris = [FreezeSWDebris class];

    return self;
}
@end

/*--------------------------------------------------------------*/

@implementation FreezeSEDebris
- init
{
    [super init];
    sprite = [turret_data getSebumByName:"deb-se"];
    return self;
}
@end


@implementation FreezeSWDebris
- init
{
    [super init];
    sprite = [turret_data getSebumByName:"deb-sw"];
    return self;
}
@end
