/* firefox.m,
 *
 * Dual-machine-gun ship with light armour.  Very nasty.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "projectiles/evil-vulcan.h"
#include "seborrhea/seborrhea.h"
#include "units/firefox.h"


static SebFile *unit_data;
static SebAnimation *fire_anim;


@implementation FireFox
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(EvilVulcan); }

+ (BOOL) loadData
{
    if (not [self loadData:&unit_data :"data/firefox"])
	return NO;

    fire_anim = (SebAnimation *)[unit_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(unit_data);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 35;
    speed = 2.0;

    sprite = [[SebAnimator new] setAnimation:fire_anim];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];
    rotated_sprite = YES;

    gun = [[[[DualWeapon newWithProjectile:[EvilVulcan class]]
		setShotDelay:-8 WaveDelay:80]
	       setShotsPerWave:3]
	      setXDisplacement:25 YDisplacement:9];

    chunk_colours = CHUNK_RED;
    return self;
}

- (void) fireProjectiles
{
    if ([gun fireFromX:x Y:y Angle:angle]) {
	/* Just started firing -> reset the animation. */
	if ([(DualWeapon *)gun currentShot] == 1)
	    [(SebAnimator *)sprite resetAnimation];
    }
}
@end
