/* fear.m,
 *
 * Like Little-Deaths, but fires and spawns projectiles upon death.
 * XXX: the shadow is buggered when width=27.
 */

#include <math.h>
#include "common.h"
#include "projectiles/evil-vulcan.h"
#include "seborrhea/seborrhea.h"
#include "units/fear.h"


static SebFile *unit_data;


@implementation Fear
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(EvilVulcan); }
+ derive_loadData(unit_data, "data/fear");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 70;
    speed = 5.0;
    the_way = (SebSpline *)[unit_data getSebumByName:"path"];

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)[unit_data getSebumByName:"move-anim"]];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height] - 6;

    fire_tics = shot_delay = 40;

    /* By default, Fears will give you nukes. */
    flags |= FLAG_FIRING_ENABLED;
    flags |= FLAG_DEATH_SPAWN_NUKE_POWERUP;
    return self;
}

- (void) die
{
    /* Spawn some projectiles when we die, for nastiness. */
    double theta = 0;

    while (theta < 2 * M_PI) {
	[spawn_projectile([EvilVulcan class], x, y, NO) setAngle:theta];
	theta += deg2rad(30.0);
    }

    [super die];
}

- (void) fire
{
    if (--fire_tics <= 0) {
	spawn_projectile([EvilVulcan class], x, y, NO);
	fire_tics = shot_delay;
    }
}
@end
