/* deceiver.m,
 *
 * Annoying little ships that (usually) sneak up from behind the
 * player and threaten to touch them.  No guns.  Good for nudging the
 * player towards a certain part of the screen.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "map-editor/unit-editor.h"
#include "map-editor/unit-extras.h"
#include "seborrhea/seborrhea.h"
#include "units/deceiver.h"


static SebFile *unit_data;


@implementation Deceiver
+ derive_loadData(unit_data, "data/deceiver");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 30;
    speed = 2.5;
    angle = -M_PI_2;
    activate_y = -480;

    sprite = [unit_data getSebumByName:"deceiver"];
    shadow = [unit_data getSebumByName:"shadow"];

    /* Smaller than sprite size so can squeeze through more easily. */
    w = [sprite width]-2;
    h = [sprite height]-2;
    rotated_sprite = YES;

    chunk_colours = CHUNK_GREEN;
    return self;
}

	/* Protocol stuff. */
- derive_setActivationLine;
- derive_importUnitPropertiesWithVariableActivationLine;
- derive_exportUnitPropertiesWithVariableActivationLine;
@end


@implementation Deceiver (MapEditor)
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_activation_line(dest, x, y, activate_y);
}
@end
