/* cruiser.m,
 *
 * Lightly armoured missile ships.
 */

#include "common.h"
#include "projectiles/rocket.h"
#include "seborrhea/seborrhea.h"
#include "units/cruiser.h"


static SebFile *unit_data;


@implementation Cruiser
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Rocket); }
+ derive_loadData(unit_data, "data/cruiser");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 45;
    speed = 1.05;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)
				[unit_data getSebumByName:"move-anim"]];
    shadow = [unit_data getSebumByName:"shadow"];
    w = 36; //[sprite width];
    h = 37; //[sprite height]-10;

    gun = [[[[DualWeapon newWithProjectile:[Rocket class]]
		setShotDelay:-30 WaveDelay:75]
	       setShotsPerWave:2]
	      setXDisplacement:5 YDisplacement:12];

    chunk_colours = CHUNK_BLUE;
    return self;
}
@end
