/* conquerer.m,
 */

#include <allegro.h>
#include "common.h"
#include "projectiles/maser.h"
#include "seborrhea/seborrhea.h"
#include "units/conquerer.h"


static SebFile *unit_data;


@implementation Conquerer
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Maser); }
+ derive_loadData(unit_data, "data/conquerer");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 65;
    speed = 1.05;

    sprite = [unit_data getSebumByName:"conquerer"];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun = [[Weapon newWithProjectile:[Maser class]]
	      setShotDelay:60];

    chunk_colours = CHUNK_GREEN;
    return self;
}
@end
