/* cluster-bomb.m,
 *
 * Cluster bomb thing.  Breaks up into 2 fireballs when the player
 * gets close.
 */

#include <math.h>
#include "candy/explosion.h"
#include "common.h"
#include "player.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"
#include "sound.h"
#include "unit-seeking.h"
#include "units/all-units.h"
#include "units/cluster-bomb.h"


#define MIN_EXPLODE_DIST	50
#define MAX_EXPLODE_DIST	150


static SebFile *bomb_sebum;

/*------------------------------------------------------------*/

@implementation ClusterBomb
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Fireball);
}

+ derive_loadData(bomb_sebum, "data/cluster");
+ derive_shutdown(bomb_sebum);

- init
{
    [super init];

    health = 5;
    speed = 2.1;

    sprite = [bomb_sebum getSebumByName:"bomb2"];
    shadow = [bomb_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    chunk_colours = 0;		/* No chunks. */

    tics_to_explode = 10;

    return self;
}

- (void) die
{
    /* Don't play an explosion sound when we die. */
    health = 0;
    flags |= (FLAG_DYING|FLAG_INVINCIBLE);
}

- (void) spawnDyingExplosions
{
    /* Just spawn a small one, otherwise it'll look ridiculous. */
    spawn_candy([Explosion class], x, y, MEDIUM_LAYER);
    [self delete];
}

- (void) fire
{
    Unit *unit = FIND_CLOSEST_ALLY(x, y);
    double xx, yy, theta;

    if (!unit)
	return;

    [unit getX:&xx Y:&yy];

    if (SQ(x-xx) + SQ(y-yy) < SQ(explode_dist)) {
	theta = angle_towards_unit(x, y, unit);
	[spawn_projectile([Fireball class], x, y, NO) setAngle:theta-deg2rad(15.)];
/* 	[spawn_projectile([Fireball class], x, y, NO) setAngle:theta]; */
	[spawn_projectile([Fireball class], x, y, NO) setAngle:theta+deg2rad(15.)];
	play_panned_sample((Sebum<SebSample> *)[bomb_sebum getSebumByName:"snd"], x);
	[self die];
    }
}

- (enum THING_UPDATE_STATE) update
{
    if (tics_to_explode > 0) {
	tics_to_explode--;

	if (tics_to_explode <= 0) {
	    explode_dist = rnd_with_rng(MIN_EXPLODE_DIST, MAX_EXPLODE_DIST);
	    flags |= FLAG_FIRING_ENABLED;
	}
    }

    return [super update];
}
@end
