/* challenger.m,
 *
 * Strong space ship with a railgun.
 */

#include "common.h"
#include "map.h"
#include "projectiles/railgun.h"
#include "seborrhea/seborrhea.h"
#include "units/challenger.h"


static SebFile *unit_data;
static SebAnimation *move_anim, *fire_anim;


@implementation Challenger
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Railgun); }

+ (BOOL) loadData
{
    if (not [self loadData:&unit_data :"data/challenger"])
	return NO;

    move_anim = (SebAnimation *)[unit_data getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[unit_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(unit_data);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 90;
    speed = 1.1;

    sprite = [[SebAnimator new] setAnimation:move_anim];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height]-14;

    gun = [[[Weapon newWithProjectile:[Railgun class]]
	       setShotDelay:60]
	      setFireTics:50];

    chunk_colours = CHUNK_BLUE;
    return self;
}

- (void) fireProjectiles
{
    if ([gun fireFromX:x Y:y+18 Angle:angle]) {
	/* Restore the moving animation. */
	[(SebAnimator *)sprite setAnimation:move_anim];
    }
    else if ([(SebAnimator *)sprite getAnimation] != fire_anim &&
	     (unsigned)[gun fireTics] <= 6*([fire_anim numFrames]-1)) {
	/* Start charging up/warning the player. */
	[(SebAnimator *)sprite setAnimation:fire_anim];
    }
}
@end
