/* centipede.m,
 *
 * Long train-like ships that flies at high speed and try to ram the
 * players.  Moderately armoured head, but weak body segments.
 */

#include <allegro.h>
#include "common.h"
#include "map-editor/unit-editor.h"
#include "map.h"
#include "seborrhea/seborrhea.h"
#include "units/centipede.h"


#define CENTIPEDE_SPEED			8.0
#define CENTIPEDE_NUM_BODY_SEGMENTS	5


static SebFile *unit_sebum;

/*--------------------------------------------------------------*/

@interface CentipedeSegment: Unit
@end

/*--------------------------------------------------------------*/

@implementation Centipede
+ derive_loadData(unit_sebum, "data/centipede");
+ derive_shutdown(unit_sebum);

- init
{
    [super init];

    health = 80;
    speed = CENTIPEDE_SPEED;

    sprite = [unit_sebum getSebumByName:"head"];
    shadow = [unit_sebum getSebumByName:"shadow-head"];
    w = [sprite width] - 10;
    h = [sprite height];

    chunk_colours = CHUNK_COFFEE;
    return self;
}

- (void) activate
{
    /* Spawn the segments. */
    int i;
    int y_ = y-16-CENTIPEDE_SPEED;

    for (i = 0; i < CENTIPEDE_NUM_BODY_SEGMENTS; i++, y_ -= 12)
	spawn_unit([CentipedeSegment class], x, y_, ACTIVE_AIR_LIST, YES);
}
@end

@implementation Centipede (MapEditor)
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    /* Draw the segments of the unit. */
    Sebum<SebImage> *segment;
    int i, y_, w_, h_;

    segment = [unit_sebum getSebumByName:"segment"];
    w_ = [segment width]/2;
    h_ = [segment height]/2;
    for (i = 0, y_ = y-16; i < CENTIPEDE_NUM_BODY_SEGMENTS; i++, y_-=12)
	[segment drawTo:dest X:x-offsetX-w_ Y:y_-offsetY-h_];

    [super drawMapEditorExtras:dest];
}
@end

/*--------------------------------------------------------------*/

@implementation CentipedeSegment
- init
{
    [super init];

    speed = CENTIPEDE_SPEED;

    sprite = [unit_sebum getSebumByName:"segment"];
    shadow = [unit_sebum getSebumByName:"shadow-segment"];
    w = [sprite width];
    h = [sprite height];

    flags |= FLAG_MOVING_ENABLED;
    chunk_colours = CHUNK_COFFEE;
    return self;
}
@end
