/* bug.m,
 *
 * Weak and dispendable enemy ships.
 */

#include "common.h"
#include "projectiles/fireball.h"
#include "seborrhea/seborrhea.h"
#include "units/bug.h"


static SebFile *unit_data;


@implementation Bug
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Fireball); }
+ derive_loadData(unit_data, "data/bug");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 5;
    speed = 1.1;

    sprite = [[SebAnimator new] setAnimation:(SebAnimation *)
				[unit_data getSebumByName:"move-anim"]];
    shadow = [unit_data getSebumByName:"shadow"];
    w = 28;	//[sprite width];
    h = 36;	//[sprite height]-12;

    gun = [[[PulseWeapon newWithProjectile:[Fireball class]]
	       setShotDelay:30 WaveDelay:80]
	      setShotsPerWave:2];

    chunk_colours = CHUNK_BLUE;
    return self;
}
@end
