/* bolt.m,
 *
 * A fixed rail-gun turret.
 */

#include <math.h>
#include "candy.h"
#include "common.h"
#include "map.h"
#include "projectiles/railgun.h"
#include "seborrhea/seborrhea.h"
#include "units/bolt.h"


static SebFile *turret_data;

/*--------------------------------------------------------------*/

@interface BoltDebris: Candy
@end

/*--------------------------------------------------------------*/

@implementation Bolt
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Railgun); }
+ derive_loadData(turret_data, "data/bolt");
+ derive_shutdown(turret_data);

- init
{
    [super init];

    health = 130;
    critical_health = 65;

    sprite = [turret_data getSebumByName:"turret"];
    w = [sprite width];
    h = [sprite height];
    rotated_sprite = YES;

    gun = [[Weapon newWithProjectile:[Railgun class]]
	      setShotDelay:45];

    base_debris = [BoltDebris class];

    chunk_colours = CHUNK_SARDAUKAR;
    return self;
}
@end

/*--------------------------------------------------------------*/

@implementation BoltDebris
- init
{
    [super init];
    sprite = [turret_data getSebumByName:"deb"];
    return self;
}

- (void) draw:(BITMAP *)dest
{
    [sprite drawTo:dest X:x-offsetX Y:y-offsetY Angle:angle];
}
@end
