/* battler.m,
 */

#include "common.h"
#include "projectiles/maser.h"
#include "seborrhea/seborrhea.h"
#include "units/battler.h"


static SebFile *unit_data;


@implementation Battler
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Maser); }
+ derive_loadData(unit_data, "data/battler");
+ derive_shutdown(unit_data);

- init
{
    [super init];

    health = 40;
    speed = 1.07;

    sprite = [unit_data getSebumByName:"battler"];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun = [[Weapon newWithProjectile:[Maser class]]
	      setShotDelay:60];

    chunk_colours = CHUNK_GREEN;
    return self;
}
@end
