/* battle-cruiser.m,
 *
 * Big strong ship with two laser turrets.
 */

#include "common.h"
#include "projectiles/maser.h"
#include "seborrhea/seborrhea.h"
#include "units/battle-cruiser.h"


static SebFile *unit_data;
static SebAnimation *move_anim, *fire_anim;


@implementation BattleCruiser
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Maser); }

+ (BOOL) loadData
{
    if (not [self loadData:&unit_data :"data/battle-cruiser"])
	return NO;

    move_anim = (SebAnimation *)[unit_data getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[unit_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(unit_data);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 80;
    speed = 1.03;

    sprite = [[SebAnimator new] setAnimation:move_anim];
    shadow = [unit_data getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[DualWeapon newWithProjectile:[Maser class]]
		setShotDelay:-20 WaveDelay:100]
	       setShotsPerWave:2]
	      setXDisplacement:0 YDisplacement:15];

    chunk_colours = CHUNK_GREEN;
    return self;
}

- (void) fireProjectiles
{
    if ([gun fireFromX:x Y:y])
	[(SebAnimator *)sprite setAnimation:fire_anim];
    else if ([(SebAnimator *)sprite animationEnded]) 
	[(SebAnimator *)sprite setAnimation:move_anim];
}
@end
