/* basic-water-turret.m,
 *
 * 'Basic Water Turret' is a turret that spawns some water ripples for
 * fun.
 */

#include "common.h"
#include "candy/ripple.h"
#include "units/basic-water-turret.h"


@implementation BasicWaterTurret
- (int) receiveDamage:(int)damage type:(enum DAMAGE_TYPE)type
{
    int ret = [super receiveDamage:damage type:type];

    if (ret > 0) {
	int i;

	for (i = 0; i < ret; i++) {
	    int xx = rnd(0, w);
	    int yy = rnd(0, h);

	    spawn_candy([Ripple class], x+xx-w/2, y+yy-h/2, FLOOR_LAYER);
	}
    }

    return ret;
}
@end


@implementation BasicWaterTurret (Turret)
- (void) spawnTurretDebris
{
    /* Don't spawn any turret debris as we don't know if it'll land in
       water or on land, and we can't handle that yet. */
}
@end
