/* basic-tank-follower.m,
 *
 * 'Basic Tank Followers' are tanks that move along a path (spline)
 * rather than just at some given angle.  Really just a copy/paste
 * job.
 */

#include <allegro.h>
#include <assert.h>
#include <math.h>
#include "common.h"
#include "map.h"
#include "map-editor/unit-editor.h"
#include "units/basic-tank-follower.h"

/*--------------------------------------------------------------*/

@interface BasicTankFollower (Private)
- (void) followPath;
- (void) drawPath:(BITMAP *)dest;
@end

/*--------------------------------------------------------------*/

@implementation BasicTankFollower
- init
{
    [super init];
    speed = 99.0;
    the_way = nil;
    return self;
}

- (id) setX:(double)x_ Y:(double)y_
{
    mirror_path = (x_ <= screen_w / 2) ? NO : YES;
    path_x_displacement = mirror_path ? screen_w - x_: x_;

    /* This is just to look good in the map editor. */
    if (the_way) {
	angle = [the_way angleBetween:0 :1];
	if (mirror_path)
	    angle = M_PI - angle;
    }

    return [super setX:x_ Y:y_];
}

- (void) activate
{
    /* This current y value is the vertical origin of our path. */
    path_y_displacement = y;

    angle = [the_way angleBetween:0 :1];
    if (mirror_path)
	angle = M_PI - angle;
}

- (void) move
{
    double yy;

    if (the_way) {
	/* We want to scroll with the map. */
	yy = [current_map scrollRate];
	y -= yy;
	path_y_displacement -= yy;

	[(SebAnimatorManual *)sprite nextFrame];
	[self followPath];
	[self layTracks];
    }
    else {
	/* Don't delete us until we are off the map. */
	[(SebAnimatorManualWithDelay *)sprite setLoopMethod:LOOP_NONE];

	if (y > offsetY + screen_h + 50)
	    [self delete];
    }
}

- derive_fixedAngle;
- derive_alwaysInfluenceGameplay;
@end


@implementation BasicTankFollower (Private)
- (void) followPath
{
    enum PATH_FOLLOW_STATE ret;

    /* We need to scroll the path and unit with the map. */
    path_y_displacement += [current_map scrollRate];
    y += [current_map scrollRate];

    /* Just pretend our path is not mirrored for a tic. */
    if (mirror_path)
	x = screen_w - x;

    ret = [the_way follow:&path_progress :&x :&y :speed
		   :path_x_displacement :path_y_displacement];

    /* Now reflect the unit back across the centre of the screen. */
    if (mirror_path)
	x = screen_w - x;

    if (ret == PATH_ENDED) {
	the_way = nil;
    }
    else if (ret == PATH_REACHED_WAYPOINT) {
	double phi = [the_way angleBetween:path_progress-1 :path_progress];

	if (mirror_path)
	    phi = M_PI - phi;

	turret_angle -= angle-phi;
	angle = phi;
    }
}

- (void) drawPath:(BITMAP *)dest;
{
    int pink = makecol(0xff, 0x80, 0x80);
    int gray = makecol(0x40, 0x40, 0x40);
    unsigned int progress = 0;
    double x_ = x, y_ = y, delta_x;

    delta_x = path_x_displacement;

    if (mirror_path) x_ = screen_w - x_;
    while ([the_way follow:&progress :&x_ :&y_ :speed :delta_x :y] != PATH_ENDED) {
	if (mirror_path) x_ = screen_w - x_;

	putpixel(dest, x_-offsetX,   y_-offsetY,   pink);
	putpixel(dest, x_-offsetX-1, y_-offsetY,   gray);
	putpixel(dest, x_-offsetX+1, y_-offsetY,   gray);
	putpixel(dest, x_-offsetX,   y_-offsetY-1, gray);
	putpixel(dest, x_-offsetX,   y_-offsetY+1, gray);

	if (mirror_path) x_ = screen_w - x_;
    }
}
@end


@implementation BasicTankFollower (MapEditor)
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];

    if (the_way)
	[self drawPath:dest];
}
@end
