/* basic-formation.m,
 *
 * Ships that can change their direction of movement halfway (just
 * once).  Good for making cool looking formations.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "map-editor/unit-editor.h"
#include "map-editor/unit-extras.h"
#include "map.h"
#include "units/basic-formation.h"


@implementation BasicFormationUnit
	/* Movement. */
- (void) enableMovement
{
    /* activate_y means where to reach before starting to move in the
       direction of the specified angle.  Otherwise move down the
       screen. */
    if (y + [sprite height]/2 + activate_y >= offsetY)
        flags |= FLAG_MOVING_ENABLED;
    else
	y += speed;
}

- (void) move
{
    if (travel_range <= 0)
	angle = -M_PI_2;
    else
	travel_range -= speed;

    [super move];
}

	/* Load/Save.  Format: travel_range;activate_y;x;y;a[;flags] */
- (void) importUnitProperties:(char *)str
{
    char str2[1024];
    double a, b;

    sscanf(str, "%lf;%lf;%s", &a, &b, str2);
    [super importUnitProperties:str2];
    travel_range = a;
    activate_y = b;
}

- (char *) exportUnitProperties:(char *)str
{
    char str2[1024] = "\0";

    [super exportUnitProperties:str2];
    snprintf(str, sizeof(str2), "%g;%d;%s", travel_range, activate_y, str2);
    return str;
}

	/* Protocol stuff. */
- derive_setActivationLine;
- derive_setTravelRange(travel_range);
@end


@implementation BasicFormationUnit (MapEditor)
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_activation_line(dest, x, y, activate_y);
    draw_travel_range(dest, x, y, angle, travel_range);
}
@end
