/* basic-flyer.m
 *
 * 'Basic-flyer' comes with a gun, which it will fire.  Very simple
 * abstract class.
 */

#include "common.h"
#include "projectile.h"
#include "units/basic-flyer.h"


@implementation BasicFlyer
        /* Initialization. */
- init
{
    [super init];
    flags |= FLAG_FIRING_ENABLED;
    return self;
}

- free
{
    gun = [gun free];
    return [super free];
}

	/* Update. */
- (void) fireProjectiles
{
    /* This is the function to replace if you want to shoot 2
       projectiles or something like that. */
    [gun fireFromX:x Y:y];
}

- (void) fire
{
    if (gun)
	[self fireProjectiles];
    else
	flags &=~FLAG_FIRING_ENABLED;
}
@end
