/* fixed-turret.m,
 *
 * A turret that doesn't aim.
 */

#include "candy.h"
#include "common.h"
#include "units/basic-fixed-turret.h"


@implementation BasicFixedTurret
- init
{
    [super init];
    flags |= FLAG_FIRING_ENABLED;
    return self;
}

- free
{
    gun = [gun free];
    return [super free];
}

- (void) die
{
    [super die];

    if (base_debris) {
	Candy *candy = spawn_candy(base_debris, x, y, LOW_LAYER);;
	
	if (rotated_sprite)
	    [candy setAngle:angle];
	    
	base_debris = nil;
    }
}

- (void) fire
{
    if (gun)
	[gun fireFromX:x Y:y Angle:angle];
    else
	flags &=~FLAG_FIRING_ENABLED;
}

- (int) collisionLists
{
    return COLLIDES_WITH_PROJECTILES_AND_NUKES;
}
@end
