/* basic-activation.m,
 *
 * Abstract class for units that have a variable activation line.
 */

#include <assert.h>
#include "common.h"
#include "map-editor/unit-editor.h"
#include "map-editor/unit-extras.h"
#include "units/basic-activation.h"


@implementation BasicActivationUnit
- derive_setActivationLine;
- derive_importUnitPropertiesWithVariableActivationLine;
- derive_exportUnitPropertiesWithVariableActivationLine;
@end


@implementation BasicActivationUnit (MapEditor)
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_activation_line(dest, x, y, activate_y);
}
@end
