/* baby-boy.m,
 *
 * An annoying little chaser unit.  Very strong before it activates,
 * but weak after it opens up.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "rotate.h"
#include "seborrhea/seborrhea.h"
#include "sound.h"
#include "unit-seeking.h"
#include "units/baby-boy.h"


static SebFile *unit_data;
static SebAnimation *open_anim, *move_anim;

/*--------------------------------------------------------------*/

@interface BabyBoy (Private)
- (void) updateOpenPhase;
@end

/*--------------------------------------------------------------*/

@implementation BabyBoy
+ (BOOL) loadData
{
    if (not [self loadData:&unit_data :"data/baby-boy"])
	return NO;

    open_anim = (SebAnimation *)[unit_data getSebumByName:"open"];
    move_anim = (SebAnimation *)[unit_data getSebumByName:"move"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(unit_data);
    open_anim = nil;
    move_anim = nil;
}

- init
{
    [super init];

    health = 300;		/* But /=5 when opened up */
    speed = 0.0;
    activate_y = -100;
    open_tics = 6*8;

    sprite = [open_anim getFrame:0];
    shadow = [unit_data getSebumByName:"shadowc"];
    w = [sprite width];
    h = [sprite height] - 6;
    rotated_sprite = YES;

    chunk_colours = CHUNK_RED;
    return self;
}

- (void) enableMovement
{
    if (game_flags & FLAG_PLAYERS_ALIVE) {
	[super enableMovement];

	if (flags & FLAG_MOVING_ENABLED) {
	    play_panned_sample((Sebum<SebSample> *)[unit_data getSebumByName:"snd"], x);
    	    sprite = [[SebAnimator new] setAnimation:open_anim];
	}
    }
}

- (void) move
{
    if (open_tics > 0) {
	[self updateOpenPhase];
	return;
    }

    if (!target || !unit_exists(target, ALLY_LIST))
	target = FIND_CLOSEST_ALLY(x, y);

    if (target && speed > 0.0) {
	double theta = angle_towards_unit(x, y, target);
	limited_rotate(&angle, theta, deg2rad(1.8));
	simplify_angle(&angle);
    }

    [super move];
}
@end


@implementation BabyBoy (Private)
- (void) updateOpenPhase
{
    open_tics--;
    if (open_tics <= 0) {
	health = MAX(1, health/5);
	speed = 1.7;
	h += 6;				/* 6px extra to hit. */
	sprite = [(SebAnimator *)sprite setAnimation:move_anim];
	shadow = [unit_data getSebumByName:"shadowo"];
    }
}
@end
