/* armadillo.m,
 *
 * A tank that spray five(!) fireballs at once.  Moderate armour.
 */

#include <allegro.h>
#include <math.h>
#include "candy/tank-track.h"
#include "candy/turret.h"
#include "common.h"
#include "map.h"
#include "projectiles/fireball.h"
#include "rottrans.h"
#include "seborrhea/seborrhea.h"
#include "units/all-units.h"
#include "units/armadillo.h"


static SebFile *tank_data;
static SebAnimation *move_anim, *fire_anim;

/*------------------------------------------------------------*/

@interface ArmadilloTrack: TankTrack
@end

@interface ArmadilloTurretDebris: TurretDebris
@end

/*------------------------------------------------------------*/

@implementation Armadillo
+ (BOOL) loadPrerequisites
{
    return LOAD_PROJECTILE_DATA_FOR(Fireball);
}

+ (BOOL) loadData
{
    if (not [self loadData:&tank_data :"data/armadillo"])
	return NO;

    move_anim = (SebAnimation *)[tank_data getSebumByName:"move-anim"];
    fire_anim = (SebAnimation *)[tank_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(tank_data);
    move_anim = nil;
    fire_anim = nil;
}

- init
{
    [super init];

    health = 80;
    speed = 0.7;
    activate_y = -100;

    sprite = [[SebAnimatorManualWithDelay new] setAnimation:move_anim];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[SprayWeapon newWithProjectile:[Fireball class]]
		setShotDelay:60]
	       setShotsPerWave:5]
	      setSpray:deg2rad(15.0)];

    turret_debris = [ArmadilloTurretDebris class];
    tracks = [ArmadilloTrack class];
    track_separation_sq = SQ(16.0);

    chunk_colours = CHUNK_COFFEE;
    return self;
}

- (void) fire
{
    if ([gun fireFromX:x Y:y Angle:turret_angle])
	[(SebAnimator *)turret resetAnimation];
}
@end


@implementation Armadillo (Turret)
- (void) drawTurret:(BITMAP *)dest
{
    /* Displace the turret 5 pixels backwards, relative to the centre
       of the tank. */
    int x_ = -5.0 * cos(angle);
    int y_ = -5.0 * sin(angle);
    [self drawTurret:dest Displacement:x_ :-y_];
}
@end

/*------------------------------------------------------------*/

@implementation ArmadilloHatch
+ (BOOL) loadPrerequisites
{
    return (LOAD_UNIT_DATA_FOR(Hatch, NO) &&
	    LOAD_UNIT_DATA_FOR(Armadillo, NO));
}

- init
{
    [super init];
    spawnee = [Armadillo class];
    return self;
}

- (void) draw:(BITMAP *)dest
{
    [super draw:dest];

    /* Fade an Armadillo into existance. */
    if (spawnee && [(SebAnimatorManualWithDelay *)sprite currentFrameNumber] > 0) {
	[(<SebImage>)[tank_data getSebumByName:"hatchme"]
		     drawTo:dest X:x-offsetX Y:y-offsetY Alpha:alpha Angle:angle];
    }
}
@end

/*------------------------------------------------------------*/

@implementation ArmadilloTrack
- init
{
    [super init];
    health = max_track_life = 100;
    sprite = [tank_data getSebumByName:"tracks"];
    return self;
}
@end


@implementation ArmadilloTurretDebris
- init
{
    [super init];
    health = max_health = 65;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
