/* anvil.m,
 *
 * Strong Big-Bertha-inspired turret.
 */

#include "candy/turret.h"
#include "common.h"
#include "projectiles/plasma.h"
#include "seborrhea/seborrhea.h"
#include "sound.h"
#include "units/anvil.h"


static SebFile *turret_data;
static SebAnimation *fire_anim;

/*------------------------------------------------------------*/

@interface AnvilBaseDebris: Candy
@end

@interface AnvilTurretDebris: TurretDebris
@end

/*------------------------------------------------------------*/

@implementation Anvil
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Plasma); }

+ (BOOL) loadData
{
    if (not [self loadData:&turret_data :"data/anvil"])
	return NO;

    fire_anim = (SebAnimation *)[turret_data getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(turret_data);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 150;
    critical_health = 75;

    sprite = [turret_data getSebumByName:"stand"];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    gun = [[Weapon newWithProjectile:[Plasma class]]
	      setShotDelay:40];

    base_debris   = [AnvilBaseDebris class];
    turret_debris = [AnvilTurretDebris class];
    chunk_colours = CHUNK_RED;
    return self;
}

- (void) fire
{
    if ([gun fireTics] == 1) {
	play_panned_sample((Sebum<SebSample> *)[turret_data getSebumByName:"snd"], x);
	[(SebAnimator *)turret setAnimation:fire_anim];
    }
    [super fire];
}
@end

/*------------------------------------------------------------*/

@implementation AnvilBaseDebris
- init
{
    [super init];
    sprite = [turret_data getSebumByName:"deb"];
    return self;
}
@end

@implementation AnvilTurretDebris
- init
{
    [super init];
    health = max_health = 100;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
