/* unit-intern.m,
 *
 * The unit's lists.  You aren't supposed to use these directly.
 */

#include <assert.h>
#include "unit-intern.h"


List *air_list, *active_air_list;
List *ground_list, *active_ground_list;
List *ally_list;			/* Includes robots and satellites. */


List *unit_list_number_to_list(enum UNIT_LIST list)
{
    /* Note: You are not supposed to mix two unit list numbers to
       check two lists (the way you can when checking collision, for
       example). */

    switch (list) {
      case ACTIVE_AIR_LIST:	return active_air_list;
      case ACTIVE_GROUND_LIST:	return active_ground_list;
      case INACTIVE_AIR_LIST:	return air_list;
      case INACTIVE_GROUND_LIST:return ground_list;
      case ALLY_LIST:		return ally_list;

      default:
	  return nil;
    }
}


void unit_intern_init(void)
{
    ally_list = [LIST_NEW];		assert(ally_list);
    air_list = [LIST_NEW];		assert(air_list);
    active_air_list = [LIST_NEW];	assert(active_air_list);
    ground_list = [LIST_NEW];		assert(ground_list);
    active_ground_list = [LIST_NEW];    assert(active_ground_list);
}


void unit_intern_shutdown(void)
{
#define SHUTDOWN_LIST(l)	{ if (l) l = [l free]; }

    SHUTDOWN_LIST(air_list);
    SHUTDOWN_LIST(active_air_list);
    SHUTDOWN_LIST(ground_list);
    SHUTDOWN_LIST(active_ground_list);
    SHUTDOWN_LIST(ally_list);

#undef SHUTDOWN_LIST
}
