/* tiles.m,
 *
 * A big global tiles Sebum for easy use.
 */

#include "seborrhea/seborrhea.h"
#include "tile.h"


static SebFile *tiles_sebum;


Sebum<SebImage> *get_tile_by_index(unsigned int i)
{
    return [tiles_sebum getNthSebum:i];
}

Sebum<SebImage> *get_tile_by_name(const char *name)
{
    char *name_;

    /* XXX */
    if ((name_ = strrchr(name, '/')) != NULL)
	name_++;
    else
	name_ = (char *)name;

    return [tiles_sebum getSebumByName:name_];
}

int num_tiles(void)
{
    return [tiles_sebum numElements];
}

BOOL load_tiles_sebum(const char *dirname)
{
    /* XXX: Loading a bad sebum should not free the whole thing. */
    if ([tiles_sebum loadSebumDirectory:dirname]) {
	return YES;
    }
    else {
	tiles_sebum = [SebFile new];
	return NO;
    }
}

int tiles_init(void)
{
    tiles_sebum = [SebFile new];
    return 0;
}

void tiles_shutdown(void)
{
    tiles_sebum = [tiles_sebum free];
}
