/* strdup.m,
 */

#include <assert.h>
#include <string.h>
#include "seborrhea/strdup.h"


void delimited_strdup(char *dest, const char *start, const char *end, size_t size)
{
    int n = end - start;

    assert(n > 0 && (unsigned int)n < size - 1);
    strncpy(dest, start, n);
    dest[n] = '\0';
}

