/* sebum.m,
 *
 * The most basic of all Seborrhea objects: Sebum.  Containers,
 * animations, images, sounds, etc are all sub-classes of this.
 */

#include <stdlib.h>
#include "seborrhea/sebum.h"


@implementation Sebum
- initWithName: (const char *)name_
{
    [self init];
    name = strdup(name_);
    return self;
}

- free
{
    if (name) {
	free(name);
	name = NULL;
    }
    return [super free];
}

- (const char *) name
{
    return name;
}
@end
