/* seborrhea.m,
 *
 * Seborrhea datafile system thingie.
 */

#include <assert.h>
#include <time.h>
#include "maybe-alrand.h"
#include "seborrhea/container-animation.h"
#include "seborrhea/container-file.h"
#include "seborrhea/seborrhea-command.h"
#include "seborrhea/seborrhea-common.h"
#include "seborrhea/seborrhea-debug.h"
#include "seborrhea/seborrhea-property.h"
#include "seborrhea/seborrhea.h"


/*--------------------------------------------------------------*/

static BOOL seborrhea_ignore_file(const char *_1, unsigned int _2, unsigned int _3, Token *_4[], Sebum<SebContainer> *_5, DirectoryList *_6);
static void seborrhea_animation_properties(Sebum *seb, unsigned int argc, Token *argv[]);
static void seborrhea_image_pivot(Sebum *seb, unsigned int argc, Token *argv[]);
static void seborrhea_sound_properties(Sebum *seb, unsigned int argc, Token *argv[]);

/*--------------------------------------------------------------*/

@interface SeborrheaInit
@end

@implementation SeborrheaInit
+ (void) load
{
    /* Add the "ignore" metafile command. */
    seborrhea_register_metafile_command("ignore", seborrhea_ignore_file);

    /* Some metafile properties. */
    seborrhea_register_metafile_property("animation-properties", seborrhea_animation_properties);
    seborrhea_register_metafile_property("image-pivot", seborrhea_image_pivot);
    seborrhea_register_metafile_property("sound-properties", seborrhea_sound_properties);

    /* Alrand because Windows' rand() is dumb. */
    alrand_init();
    alrand_srand(time(0));
    alrand_set_global_generator_type(alrand_type_mersenne_twister);
}
@end

/*--------------------------------------------------------------*/

static BOOL seborrhea_ignore_file(const char *_1, unsigned int _2, unsigned int _3, Token *_4[], Sebum<SebContainer> *_5, DirectoryList *_6)
{
    (void)_1, (void)_2, (void)_3, (void)_4, (void)_5, (void)_6;
    return YES;
}

static void seborrhea_animation_properties(Sebum *seb, unsigned int argc, Token *argv[])
{
    enum SEB_ANIMATION_LOOP_METHOD method;
    assert(seb && [seb isKindOf:[SebAnimation class]] && "Received sebum is not an animation!");
    assert(argc == 3 && "Wrong number of arguments received for animation-properties!");
    assert([argv[1] isType:TOKEN_FIXNUM] &&
	   [argv[2] isType:TOKEN_SYMBOL] && "Wrong types of arguments received for animation-properties!");

    method = (streq([argv[2] getSymbol], "loop-forward") ? LOOP_FORWARD :
	      streq([argv[2] getSymbol], "loop-ping-pong") ? LOOP_PING_PONG : LOOP_NONE);
    [(SebAnimation *)seb setFrameDelay:[argv[1] getFixnum] LoopMethod:method];
}

static void seborrhea_image_pivot(Sebum *seb, unsigned int argc, Token *argv[])
{
    assert(seb && [seb conformsTo:@protocol(SebImage)] && "Received sebum is not an image!");
    assert(argc == 3 && "Wrong number of arguments received for image-pivot!");
    assert([argv[1] isType:TOKEN_FIXNUM] &&
	   [argv[2] isType:TOKEN_FIXNUM] && "Wrong types of arguments received for image-pivot!");

    [(<SebImage>)seb setPivotX:[argv[1] getFixnum] Y:[argv[2] getFixnum]];
}

static void seborrhea_sound_properties(Sebum *seb, unsigned int argc, Token *argv[])
{
    assert(seb && [seb conformsTo:@protocol(SebSample)] && "Received sebum is not a sample!");
    assert(argc == 2 && "Wrong number of arguments received for sound-properties!");
    assert([argv[1] isType:TOKEN_FIXNUM] && "Wrong types of arguments received for sound-properties!");

    [(<SebSample>)seb setDefaultVolume:[argv[1] getFixnum]];
}
