/* seborrhea-property.m,
 *
 * Metafile property handlers for Seborrhea.
 */

#include <assert.h>
#include "seborrhea/seborrhea-common.h"
#include "seborrhea/seborrhea-debug.h"
#include "seborrhea/seborrhea-property.h"


metafile_property_handler_t metafile_property_handlers[MAX_METAFILE_PROPERTY_HANDLERS];


void seborrhea_register_metafile_property(const char *prop, property_handler_proc_t proc)
{
    int i;
    assert(prop && proc);

    for (i = 0; i < MAX_METAFILE_PROPERTY_HANDLERS; i++) {
	if (metafile_property_handlers[i].proc)
	    continue;

	metafile_property_handlers[i].prop = prop;
	metafile_property_handlers[i].proc = proc;

	SEBORRHEA_MESSAGE(stdout, "[Seborrhea] Added metafile property %s. (%d/%d)\n",
			  prop, i+1, MAX_METAFILE_PROPERTY_HANDLERS);
	return;
    }
    assert("[Seborrhea] Out of space for property handlers" && NO);
}
