/* seborrhea-filetype.m,
 *
 * File extension handlers for Seborrhea.
 */

#include <assert.h>
#include "seborrhea/seborrhea-debug.h"
#include "seborrhea/seborrhea-filetype.h"


filename_extension_handler_t filename_extension_handlers[MAX_FILETYPE_HANDLERS];


void seborrhea_register_filetype_handler(const char *ext, filetype_handler_proc_t proc)
{
    int i;
    assert(ext && proc);

    for (i = 0; i < MAX_FILETYPE_HANDLERS; i++) {
	if (filename_extension_handlers[i].proc)
	    continue;

	filename_extension_handlers[i].ext = ext;
	filename_extension_handlers[i].proc = proc;

	SEBORRHEA_MESSAGE(stdout, "[Seborrhea] Added handler for %s. (%d/%d)\n",
			  ext, i+1, MAX_FILETYPE_HANDLERS);
	return;
    }
    assert("[Seborrhea] Out of space for filetype handlers" && NO);    
}
