/* seborrhea-datadir.m,
 *
 * Directories for Seborrhea to look for data in.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "seborrhea/seborrhea-common.h"
#include "seborrhea/seborrhea-datadir.h"
#include "seborrhea/seborrhea-debug.h"


#define MAX_ROOT_DIRECTORIES	16


char *seborrhea_data_root_directories[MAX_ROOT_DIRECTORIES] = {};


void seborrhea_add_root_directory(const char *dir)
{
    int i;
    char *dirname;
    assert(dir);

    /* Make sure 'dir' has a trailing slash. */
    i = strlen(dir);
    if (i > 0 && dir[i-1] == '/') {
	dirname = strdup(dir);
    }
    else {
	dirname = malloc(sizeof(char) * (i+2));
	snprintf(dirname, i+2, "%s/", dir);
    }

    for (i = 0; i < MAX_ROOT_DIRECTORIES; i++) {
	if (not seborrhea_data_root_directories[i]) {
	    seborrhea_data_root_directories[i] = dirname;
	    SEBORRHEA_MESSAGE(stdout, "[Seborrhea] Added data directory %s\n", dirname);
	    return;
	}
	if (streq(dirname, seborrhea_data_root_directories[i])) {
	    free(dirname);
	    return;
	}
    }

    free(dirname);
    assert(0);
}


void seborrhea_free_root_directories(void)
{
    int i;

    for (i = 0; i < MAX_ROOT_DIRECTORIES; i++) {
	if (seborrhea_data_root_directories[i]) {
	    free(seborrhea_data_root_directories[i]);
	    seborrhea_data_root_directories[i] = NULL;
	}
	else
	    break;
    }

    /* XXX: this shouldn't go here, but I'm lazy. */
/*     alrand_exit(); */
}
