/* seborrhea-command.m,
 *
 * Metafile command handlers for Seborrhea.
 */

#include <assert.h>
#include "seborrhea/seborrhea-command.h"
#include "seborrhea/seborrhea-common.h"
#include "seborrhea/seborrhea-debug.h"


metafile_command_handler_t metafile_command_handlers[MAX_METAFILE_COMMANDS];


void seborrhea_register_metafile_command(const char *command, command_handler_proc_t proc)
{
    int i;
    assert(command && proc);

    for (i = 0; i < MAX_METAFILE_COMMANDS; i++) {
	if (metafile_command_handlers[i].proc)
	    continue;

	metafile_command_handlers[i].command = command;
	metafile_command_handlers[i].proc = proc;

	SEBORRHEA_MESSAGE(stdout, "[Seborrhea] Added metafile command %s.\n",
			  command);
	return;
    }

    assert("[Seborrhea] Out of space for command handlers" && NO);
}
