/* container-shuffle.m,
 *
 * SebShuffles are similar to SebQueues, except when the entire queue
 * has been used up, the queue will be randomised.
 */

#include <assert.h>
#include "maybe-alrand.h"
#include "seborrhea/container-shuffle.h"
#include "seborrhea/seborrhea-common.h"
#include "seborrhea/sebum-music.h"

/*--------------------------------------------------------------*/

@interface SebShuffle (Private)
- (void) swapSebums:(const unsigned int)a :(const unsigned int)b;
- (void) shuffle;
@end

/*--------------------------------------------------------------*/

@implementation SebShuffle
- (BOOL) checkValidChild:(Sebum *)child
{
    /* XXX */
    if (not [child conformsTo:@protocol(SebMusic)]) {
	fprintf(stderr, "[%s:%s] Attempted to add %s (%s) into queue of SebMusic!\n",
		[[self class] name], [self name],
		[child name], [[child class] name]);
	return NO;
    }

    return YES;
}

- (Sebum *) getRandomSebum
{
    if (next_element == 0) {
	[self shuffle];
    }

    return [super getRandomSebum];
}
@end


@implementation SebShuffle (Private)
- (void) swapSebums:(const unsigned int)a :(const unsigned int)b
{
    Sebum *c;
    assert((a < nelements) &&
	   (b < nelements));

    c = element[a];
    element[a] = element[b];
    element[b] = c;
}

- (void) shuffle
{
    unsigned int a, b;

    for (a = 0; a < nelements; a++) {
	alrand_uint32_t r = alrand_rand();
	b = r % nelements;

	[self swapSebums:a :b];
    }
}
@end
