/* container-queue.m,
 *
 * Queues are files in which all of the children are of the same
 * class.  They differ from lumps in that we always receive items
 * in order, instead of randomly.
 */

#include <assert.h>
#include "seborrhea/container-queue.h"
#include "seborrhea/seborrhea-common.h"


@implementation SebQueue
- init
{
    [super init];
    process_directories = NO;
    queue_child_class = nil;
    next_element = 0;
    return self;
}

- (BOOL) checkValidChild:(Sebum *)child
{
    /* Bloody dynamic typing. */
    if ((queue_child_class) &&
	(not [child isKindOf:queue_child_class])) {
	fprintf(stderr, "[%s:%s] Attempted to add %s (%s) into queue of %s!\n",
		[[self class] name], [self name],
		[child name], [[child class] name],
		[queue_child_class name]);
	return NO;
    }
    else {
	queue_child_class = [child class];
	return YES;
    }
}

- (BOOL) addToList:(Sebum *)child
{
    assert(child != nil);

    /* Check all contents are of the same type. */
    if (not [self checkValidChild:child])
	return NO;

    return [super addToList:child];
}

- (unsigned int) numElements
{
    return nelements;
}

- (Sebum *) getRandomSebum
{
    Sebum *sebum;
    assert(next_element < nelements);

    sebum = element[next_element];
    next_element = [self selectNextSebum:next_element];

    return sebum;
}

- (unsigned int) selectNextSebum:(const unsigned int)curr
{
    unsigned int next = curr+1;

    if (next >= nelements)
	next = 0;

    return next;
}
@end
