/* screenshot.m,
 *
 * Save a screenshot (F10).
 */

#include <allegro.h>
#include <stdio.h>
#include <string.h>
#include "screenshot.h"


#define MAX_FILENAME_LENGTH	16


void take_screenshot(BITMAP *bmp)
{
    static unsigned int screenshot_num = 0;
    char filename[MAX_FILENAME_LENGTH];

    do {
	snprintf(filename, sizeof filename, "shot%04d.bmp", screenshot_num);
	screenshot_num++;
    } while (exists(filename));

    if (save_bitmap(filename, bmp, NULL) != 0)
	fprintf(stderr, "[Screenshot] Could not write to '%s'.\n", filename);
}
