/* scramble-letter.m,
 *
 * GIMP logo settings: Glossy, Utopia Bold, 53.  Outline size 1.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "scramble-letter.h"
#include "seborrhea/seborrhea.h"


letter_t game_over_letters[] = {
    { "glue/game/0g",   0+21, 180, 0, 0 },
    { "glue/game/1a",  35+21, 180, 0, 0 },
    { "glue/game/2m",  71+21, 180, 0, 0 },
    { "glue/game/3e", 120+21, 180, 0, 0 },
    { "glue/game/4o", 165+21, 180, 0, 0 },
    { "glue/game/5v", 203+21, 180, 0, 0 },
    { "glue/game/6e", 239+21, 180, 0, 0 },
    { "glue/game/7r", 272+21, 180, 0, 0 },
    { NULL, 0, 0, 0, 0 }
};

letter_t high_score_letters[] = {
    { "glue/hi/0h",   0+13, 180, 0, 0 },
    { "glue/hi/1i",  43+13, 180, 0, 0 },
    { "glue/hi/2g",  64+13, 180, 0, 0 },
    { "glue/hi/3h", 101+13, 180, 0, 0 },
    { "glue/hi/4s", 156+13, 180, 0, 0 },
    { "glue/hi/5c", 186+13, 180, 0, 0 },
    { "glue/hi/6o", 223+13, 180, 0, 0 },
    { "glue/hi/7r", 263+13, 180, 0, 0 },
    { "glue/hi/8e", 299+13, 180, 0, 0 },
    { NULL, 0, 0, 0, 0 }
};

letter_t level_complete_letters[] = {
    { "glue/done/00l",   0+94, 200, 0, 0 },
    { "glue/done/01e",  31+94, 200, 0, 0 },
    { "glue/done/02v",  62+94, 200, 0, 0 },
    { "glue/done/03e",  98+94, 200, 0, 0 },
    { "glue/done/04l", 131+94, 200, 0, 0 },
    { "glue/done/10c",   0+24, 245, 0, 0 },
    { "glue/done/11o",  37+24, 245, 0, 0 },
    { "glue/done/12m",  76+24, 245, 0, 0 },
    { "glue/done/13p", 126+24, 245, 0, 0 },
    { "glue/done/14l", 160+24, 245, 0, 0 },
    { "glue/done/15e", 191+24, 245, 0, 0 },
    { "glue/done/16t", 223+24, 245, 0, 0 },
    { "glue/done/17e", 258+24, 245, 0, 0 },
    { "glue/done/18",  291+24, 245, 0, 0 },	/* ! */
    { NULL, 0, 0, 0, 0 }
};

/*------------------------------------------------------------*/

void scramble_letters(letter_t ls[])
{
    int i, n;

    for (n = 0; ls[n].name; n++); /* Num letters */

    for (i = 0; i < n; i++) {
	ls[i].theta = i * deg2rad(360.0/n);
	ls[i].dist = screen_h*3/4;
    }
}

void unscramble_letters(letter_t ls[])
{
    int i;

    for (i = 0; ls[i].name; i++) {
	ls[i].theta += deg2rad(4.0);

	ls[i].dist = (ls[i].dist * 0.98) - 2.0;
	if (ls[i].dist < 0.0)
	    ls[i].dist = 0.0;
    }
}

void draw_letters(BITMAP *dest, letter_t ls[])
{
    int i;

    for (i = 0; ls[i].name; i++) {
	letter_t *l = &ls[i];
	Sebum<SebImage> *seb = [base_sebum getSebumByName:l->name];

	if (not seb)
	    continue;

	[seb drawTo:dest X:l->x+l->dist*cos(l->theta) Y:l->y-l->dist*sin(l->theta)];
    }
}
